#include "util.h"
#include <math.h>

const double sqrt2Pi = sqrt(M_PI*2);
// -----> K
//
// SE :
double K(Vector<double> &X)
 { double kValue = 0;
 	for (int i = X.minIndex();i <= X.maxIndex();i++)
       kValue = X[i]*X[i];
   return exp(-0.5*kValue) / pow(sqrt2Pi, X.size());
 }

double K(double x)
 { return exp(x*x * -0.5) / sqrt2Pi;
 }

// -----> mean
//
// SE :
double mean(Vector<double> &aVector)
 { double		sum = 0;
 	for (int i = aVector.minIndex();i <= aVector.maxIndex();i++)
   	sum += aVector[i];
	return sum / aVector.size();
 }
// -----> sigma
//
// SE :
double sigma(Vector<double> &aVector)
 { double		meanValue = mean(aVector),
 			sum = 0,
         tmp;

 	for (int i = aVector.minIndex();i <= aVector.maxIndex();i++)
    { tmp = aVector[i] - meanValue;
   	sum += tmp * tmp;
    }
	return sqrt(sum / aVector.size());
 }

// -----> W_i_j_Xt
//
// SE :
double W_i_j_Xt(Vector <Vector<double> > &X, int i, int j, int t, int T, double h, int k)
 { Vector <double> 	tmpVector;
 	double 						sum = 0;
   for (int ii = k;ii < j;ii++)
    { tmpVector = X[t];
    	tmpVector -= X[ii];
    	tmpVector /= h;
      sum += K(tmpVector);
    }
   for (int ii = j + 1;ii <= T;ii++)
    { tmpVector = X[t];
    	tmpVector -= X[ii];
    	tmpVector /= h;
      sum += K(tmpVector);
    }
   tmpVector = X[t];
   tmpVector -= X[i];
   tmpVector /=h;
   if (sum == 0)
#ifndef NO_ZERO
      throw StatError("W_i_j_Xt","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum = 1.0e-300;
#endif

	return K(tmpVector) / sum;
 }



/*
  *
  * relatif  mean
  *
*/


// -----> R_j_Xt
//
// SE :
double R_j_Xt(Vector <Vector<double> > &X, Vector<double > &Y, int j, int t, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

   for (int i = k;i < j; i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      sum2 += Y[i] *kValue;
    }
	for (int i = j+1;i <= T;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      sum2 += Y[i] *kValue;
    }
   if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("R_j_Xt","sum1 = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif
   return sum2 / sum1;
 }

// -----> CVmean
//
// SE :
double CVmean(Vector <Vector<double> > &X, Vector<double > &Y, int T, int k, double h)
 { double 			sum = 0;
   for (int j = k;j <= T;j++)
    { double tmp = Y[j] - R_j_Xt(X, Y,j, j, T, h, k);
      sum += tmp*tmp;
    }
	return sum/(T - k + 1);
 }
// -----> W_t_mean_Xn
//
// SE :
double W_t_mean_Xn(Vector <Vector <double> > &X, int t, int n, int T, double hOp, int k)
 { Vector <double> 	tmpVector;
 	double 						sum = 0;
   for (int ii = k;ii <= T;ii++)
    { tmpVector = X[n];
    	tmpVector -= X[ii];
    	tmpVector /= hOp;
      sum += K(tmpVector);
    }
   tmpVector = X[n];
   tmpVector -= X[t];
   tmpVector /=hOp;

   if (sum == 0)
#ifndef NO_ZERO
      throw StatError("W_t_mean_Xn","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum = 1.0e-300;
#endif
	return K(tmpVector) / sum;
 }
// -----> Z_nm_mean
//
// SE :
double Z_nm_mean(Vector <Vector <double> > &X, Vector <double> &Y, int n, int T, double hOp, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

	for (int i = k;i <= n;i++)
    { tmpVector = X[T];
    	tmpVector -= X[i];
      tmpVector /= hOp;
      sum1 += (kValue = K(tmpVector));
      sum2 += Y[i] *kValue;
    }
	if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("Z_nm_mean","sum1 = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }
// -----> F_y_Xn
//
// SE :
double F_y_Xn(Vector <Vector <double> > &X, Vector <double> &Y, double y, int n, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

	for (int i = k;i <= n;i++)
    { tmpVector = X[i];
    	tmpVector -= X[T];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      if (Y[i] <= y)
      	sum2 += kValue;
    }
	if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("Fmean_y_Xn","sum1 = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }



/*
  *
  * Relatif  median
  *
*/


// -----> F_j_y_Xt
//
// SE :
double F_j_y_Xt(Vector <Vector <double> > &X, Vector <double> &Y, int j, double y, int t, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

   for (int i = k;i < j; i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      if (Y[i] <= y)
      	sum2 += kValue;
    }
	for (int i = j+1;i <= T;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      if (Y[i] <= y)
         sum2 += kValue;
    }
   if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("F_j_y_Xt","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }
// -----> CV1Median
//
// SE :
double CV1Median(Vector <Vector <double> > &X, Vector <double> &Y,int T, double h, int k)
 { double		sum1 = 0,
 					sum2;

   for (int t =k;t <= T;t++)
    {
    	for (int i = k;i <= T;i++)
       {	if (Y[t] <= Y[i])
          	sum2 = 1 - F_j_y_Xt(X, Y, t, Y[i], t, T, h, k);
         else
         	sum2 = - F_j_y_Xt(X, Y, t, Y[i], t, T, h, k);
			sum1 += sum2 * sum2;											//      sum2 -= F_j_y_Xt(X, Y, t, Y[i], t, T, h, k);
		 }																		//      sum2 -= F_j_y_Xt(X, Y, t, Y[t], t, T, h, k);
    }
	return sum1 / (T - k + 1);
 }
// -----> W_t_median_Xn
//
// SE :
double W_t_median_Xn(Vector <Vector <double> > &X, int t, int n, int T, double hOp, int k)
 { Vector <double> 	tmpVector;
 	double 						sum = 0;
   for (int ii = k;ii <= T;ii++)
    { tmpVector = X[n];
    	tmpVector -= X[ii];
    	tmpVector /= hOp;
      sum += K(tmpVector);
    }
   tmpVector = X[n];
   tmpVector -= X[t];
   tmpVector /=hOp;
	return K(tmpVector) / sum;
 }
// -----> F1_y_Xn
//
// SE :
double F1_y_Xn(Vector <Vector <double> > &X, Vector <double> &Y, double y, int n, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

	for (int t = k;t <= n;t++)
    { tmpVector = X[T];
    	tmpVector -= X[t];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      if (Y[t] <= y)
      	sum2 += kValue;
    }
   if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("F1_y_Xn","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }
// -----> Z_nm_median1
//
// SE :
#define SEARCH_FACTOR_Z1 2
double Z_nm_median1(Vector <Vector <double> > &X, Vector <double> &Y, int T, double h, int k, int n)
 { double 	yMin = Y.min(),
 				yMax = Y.max(),
            step;

	step = (yMax - yMin) / (SEARCH_FACTOR_Z1*Y.size());

   for (int l = 0;l <= SEARCH_FACTOR_Z1*Y.size();l++)
   	if (F1_y_Xn(X,Y, yMin + l*step, n, T, h, k) >= 0.5)
      	return yMin + l*step;
   throw StatError("Z_nm_median1","F1_y_Xn never > 0.5.");
 }
//-----> mu_sum
//
// SE :
double mu_sum(Vector<Vector <double> > &X, Vector <double> &Y, int t, int T, double h, int k, double alpha)
 { double 							sumValue = 0;
 	Vector<double>		tmpVector;
 	for (int i = k;i < t;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sumValue += fabs(Y[i] - alpha)*K(tmpVector);
    }
 	for (int i = t + 1;i <= T;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sumValue += fabs(Y[i] - alpha)*K(tmpVector);
    }
	return sumValue;
 }
// -----> mu_t_Xt
//
// SE :
#define SEARCH_FACTOR_MU	2
double mu_t_Xt(Vector <Vector <double> > &X, Vector <double> &Y, int t, int T, double h, int k)
 { double 	step = (Y.max() - Y.min()) / (SEARCH_FACTOR_MU*Y.size()),
 				alphaMin, sumMin, alpha, sumAlpha;

 	alphaMin = Y.min();
   sumMin = mu_sum(X, Y, t, T, h, k, alphaMin);

 	for (int l = 1;l <= SEARCH_FACTOR_MU*Y.size();l++)
    { alpha = Y.min() + l*step;
    	if ((sumAlpha = mu_sum(X, Y, t, T, h, k, alpha)) < sumMin)
       { sumMin = sumAlpha;
       	alphaMin = alpha;
       }

    }
   return alphaMin;
 }
// -----> CV2Median
//
// SE :
double CV2Median(Vector <Vector <double> > &X, Vector <double> &Y,int T, double h, int k)
 { double	sum = 0,
 				tmp;


 	for (int t = k;t <= T;t++)
    { tmp = Y[t] - mu_t_Xt(X, Y, t, T, h, k);
    	sum += tmp*tmp;
    }
   return sum / (T - k + 1);
 }
// -----> sum_Z_nm_median2
//
// SE :
double sum_Z_nm_median2(Vector <Vector <double> > &X, Vector <double> &Y, int T, double h, int k, int n, double alpha)
 { double 							sum = 0,
 										sum2 = 0,
                              kValue;
 	Vector<double>      tmpVector;

 	for (int t = k;t <= n;t++)
    { tmpVector = X[T];
    	tmpVector -= X[t];
      tmpVector /= h;
      kValue = K(tmpVector);
      sum2 += kValue;
      sum += fabs(Y[t] - alpha)*kValue;
    }
   if (sum2 == 0)
#ifndef NO_ZERO
      throw StatError("sum_Z_nm_median2","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum2 = 1.0e-300;
#endif

   return sum/sum2;
 }
// -----> Z_nm_median2
//
// SE :
#define SEARCH_FACTOR_Z_NM_MEDIAN2		2
double Z_nm_median2(Vector <Vector <double> > &X, Vector <double> &Y, int T, double h, int k, int n)
 { double 	step = (Y.max() - Y.min()) / (SEARCH_FACTOR_Z_NM_MEDIAN2*Y.size()),
 				alphaMin, sumMin, alpha, sumAlpha;

 	alphaMin = Y.min();
   sumMin = sum_Z_nm_median2(X, Y, T, h, k, n, alphaMin);

 	for (int l = 1;l <= SEARCH_FACTOR_Z_NM_MEDIAN2*Y.size();l++)
	 { alpha = Y.min() + l*step;
    	if ((sumAlpha = sum_Z_nm_median2(X, Y, T, h, k, n, alpha)) < sumMin)
       { sumMin = sumAlpha;
       	alphaMin = alpha;
       }
    }
   return alphaMin;
 }
// -----> f_j_y_Xt
//
// SE :
double f_j_y_Xt(Vector <Vector <double> > &X, Vector <double> &Y, int j, double y, int t, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

	for (int i = k;i < j;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      sum2 += K((y - Y[i]) / h) * kValue;
    }
	for (int i = j+1;i <= T;i++)
    { tmpVector = X[t];
    	tmpVector -= X[i];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      sum2 += K((y - Y[i]) / h) * kValue;
    }
#ifndef NO_ZERO
      throw StatError("f_j_y_Xt","sum1 = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }
// -----> theta_j_Xt
//
// SE :
#define SEARCH_FACTOR_THETA_J_XT 2
double theta_j_Xt(Vector <Vector <double> > &X, Vector <double> &Y, int j, int t, int T, double h, int k)
 { double 	step = (Y.max() - Y.min()) / (SEARCH_FACTOR_THETA_J_XT*Y.size()),
 				yMax, sumMax, y, sumY;

 	yMax = Y.min();
   sumMax = f_j_y_Xt(X, Y, j, yMax, t, T, h, k);

 	for (int l = 1;l <= SEARCH_FACTOR_THETA_J_XT*Y.size();l++)
	 { y = Y.min() + l*step;
    	if ((sumY = f_j_y_Xt(X, Y, j, y, t, T, h, k)) > sumMax)
       { sumMax = sumY;
       	yMax = y;
       }
    }
   return yMax;
 }
// -----> CVMode
//
// SE :
double CVMode(Vector <Vector <double> > &X, Vector <double> &Y, int T, double h, int k)
 { double 	sum = 0;;
 	for (int t = k;t <= T;t++)
		sum += Y[t] - theta_j_Xt(X, Y, t, t, T, h, k);
   return sum / (T - k +1);
 }
// -----> W_t_mode_Xn
//
// SE :
double W_t_mode_Xn(Vector <Vector <double> > &X, int t, int n, int T, double hOp, int k)
 { /*static*/ Vector<double>	tmpVector;
 	double						sum = 0;

 	for (int i = k;i <= T;i++)
    { tmpVector = X[n];
    	tmpVector -= X[i];
      tmpVector /= hOp;
      sum += K(tmpVector);
    }
	tmpVector = X[n];
   tmpVector -= X[t];
   tmpVector /= hOp;

   if (sum == 0)
#ifndef NO_ZERO
      throw StatError("sum_Z_nm_median2","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum = 1.0e-300;
#endif

   return K(tmpVector) / sum;
 }
// -----> f_y_Xn
//
// SE :
double f_y_Xn(Vector <Vector <double> > &X, Vector <double> &Y, double y, int n, int T, double h, int k)
 { Vector<double>	tmpVector;
   double						sum1 = 0,
   								sum2 = 0,
                           kValue;

	for (int t = k;t <= n;t++)
    { tmpVector = X[T];
    	tmpVector -= X[t];
      tmpVector /= h;
      sum1 += (kValue = K(tmpVector));
      sum2 += K((y - Y[t]) / h) * kValue;
    }

   if (sum1 == 0)
#ifndef NO_ZERO
      throw StatError("sum_Z_nm_median2","sum = 0 !, Set NO_ZERO to correct");
#else
    	sum1 = 1.0e-300;
#endif

   return sum2 / sum1;
 }
// -----> Z_nm_mode
//
// SE :
#define SEARCH_FACTOR_Z_NM_MODE 2
double Z_nm_mode(Vector <Vector <double> > &X, Vector <double> &Y, int n, int T, double h, int k)
 { double 	step = (Y.max() - Y.min()) / (SEARCH_FACTOR_Z_NM_MODE*Y.size()),
 				yMax, sumMax, y, sumY;

 	yMax = Y.min();
   sumMax = f_y_Xn(X, Y, yMax, n, T, h, k);

 	for (int l = 1;l <= SEARCH_FACTOR_Z_NM_MODE*Y.size();l++)
	 { y = Y.min() + l*step;
    	if ((sumY = f_y_Xn(X, Y, y, n, T, h, k)) > sumMax)
       { sumMax = sumY;
       	yMax = y;
       }
    }
   return yMax;
 }
